/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.common.capability.wrappers.InfinityBucketWrapper;
import committee.nova.mods.avaritia.common.item.resources.ResourceItem;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityBucketItem
extends ResourceItem {
    public static final String FLUIDS_NBT = "Fluids";
    public static final String FLUID_ID_KEY = "Id";
    public static final String FLUID_AMOUNT_KEY = "Amount";

    public InfinityBucketItem() {
        super(ModRarities.LEGEND, "infinity_bucket", true, new Item.Properties().m_41487_(1));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new InfinityBucketWrapper(stack);
    }

    @Override
    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        List<FluidStack> fluids = InfinityBucketItem.getFluids(pStack);
        NumberFormat formater = DecimalFormat.getInstance();
        for (FluidStack fluid : fluids) {
            MutableComponent component = MutableComponent.m_237204_((ComponentContents)fluid.getDisplayName().m_214077_());
            component.m_130946_(": " + formater.format(fluid.getAmount()) + " mB");
            pTooltipComponents.add((Component)component);
        }
    }

    public void m_6883_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        Player player;
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (pEntity instanceof Player && (player = (Player)pEntity).m_150109_().m_36056_() == pStack) {
            FluidStack firstContained = InfinityBucketItem.getFluids(pStack).stream().findFirst().orElse(FluidStack.EMPTY);
            NumberFormat formater = DecimalFormat.getInstance();
            String displayName = firstContained.getDisplayName().getString();
            String amount = formater.format(firstContained.getAmount());
            player.m_5661_((Component)Component.m_237110_((String)"tooltip.infinity_bucket.message", (Object[])new Object[]{displayName, amount}), true);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        FluidActionResult placeResult;
        FluidStack drained;
        FluidActionResult pickUpResult;
        boolean canPickUp;
        ItemStack itemStack = pPlayer.m_21120_(pUsedHand);
        if (pPlayer.m_6047_()) {
            List<FluidStack> fluids = InfinityBucketItem.getFluids(itemStack);
            if (fluids.isEmpty()) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            FluidStack firstContained = fluids.remove(0);
            fluids.add(firstContained);
            InfinityBucketItem.setFluids(itemStack, fluids);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).resolve().orElse(null);
        if (fluidHandler == null) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        BlockHitResult hitResult = InfinityBucketItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        BlockPos hitPos = hitResult.m_82425_();
        BlockState hitState = pLevel.m_8055_(hitPos);
        Block hitBlock = hitState.m_60734_();
        boolean bl = canPickUp = hitBlock instanceof IFluidBlock || hitBlock instanceof BucketPickup;
        if (pLevel.m_7966_(pPlayer, hitPos) && canPickUp && (pickUpResult = FluidUtil.tryPickUpFluid((ItemStack)itemStack, (Player)pPlayer, (Level)pLevel, (BlockPos)hitPos, (Direction)hitResult.m_82434_())).isSuccess()) {
            return InteractionResultHolder.m_19090_((Object)pickUpResult.getResult());
        }
        BlockPos placePos = hitPos.m_121955_(hitResult.m_82434_().m_122436_());
        if (pLevel.m_7966_(pPlayer, placePos) && (drained = fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE)).getAmount() == 1000 && (placeResult = FluidUtil.tryPlaceFluid((Player)pPlayer, (Level)pLevel, (InteractionHand)pUsedHand, (BlockPos)placePos, (ItemStack)itemStack, (FluidStack)drained)).isSuccess()) {
            fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            return InteractionResultHolder.m_19090_((Object)placeResult.getResult());
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public static List<FluidStack> getFluids(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return new ArrayList<FluidStack>();
        }
        if (!nbt.m_128425_(FLUIDS_NBT, 9)) {
            return new ArrayList<FluidStack>();
        }
        return nbt.m_128437_(FLUIDS_NBT, 10).stream().filter(tag -> tag.m_7060_() == 10).map(tag -> InfinityBucketItem.loadFluidStackFromNBT((CompoundTag)tag)).collect(Collectors.toList());
    }

    public static void setFluids(ItemStack stack, List<FluidStack> fluids) {
        ListTag listTag = new ListTag();
        for (FluidStack fluid : fluids) {
            listTag.add((Object)InfinityBucketItem.writeFluidStackToNBT(fluid, new CompoundTag()));
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(FLUIDS_NBT, (Tag)listTag);
        stack.m_41751_(tag);
    }

    @NotNull
    public static FluidStack loadFluidStackFromNBT(CompoundTag nbt) {
        if (nbt == null) {
            return FluidStack.EMPTY;
        }
        if (!nbt.m_128425_(FLUID_ID_KEY, 8)) {
            return FluidStack.EMPTY;
        }
        ResourceLocation fluidName = new ResourceLocation(nbt.m_128461_(FLUID_ID_KEY));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        int amount = nbt.m_128451_(FLUID_AMOUNT_KEY);
        return new FluidStack(fluid, amount);
    }

    @NotNull
    public static CompoundTag writeFluidStackToNBT(FluidStack fluidStack, CompoundTag nbt) {
        nbt.m_128359_(FLUID_ID_KEY, InfinityBucketItem.getFluidName(fluidStack));
        nbt.m_128405_(FLUID_AMOUNT_KEY, fluidStack.getAmount());
        return nbt;
    }

    @NotNull
    public static String getFluidName(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation fluidName = ForgeRegistries.FLUIDS.getKey((Object)fluid);
        if (fluidName == null) {
            return "";
        }
        return fluidName.toString();
    }
}

